<?php
/**
 * Helper functions (plugin)
 *
 * @package prague
 * @since 1.0.0
 *
 */

/* Get list forms from Formidable Form */
if ( !function_exists( 'prague_get_fd_forms' ) ) {
  function prague_get_fd_forms($for_vc = false) {


    $forms = array( '' => '- Select form -' );
    if ($for_vc) {
        $forms = array( '- Select form -' => '' );
    }
     
     if ( ! function_exists( 'is_plugin_active' ) ) {
       include_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Require plugin.php to use is_plugin_active() below
     }

     if ( is_plugin_active( 'formidable/formidable.php' ) ) {
       global $wpdb;

       $where = array(
       'status' => array( null, '', 'published' ),
     );
     $forms_arr = FrmForm::getAll( $where, 'name' );
       if(  $forms_arr ) {
         foreach ( $forms_arr as $cform ) {

           $key = $cform->id;
           $value = $cform->name;

           if ($for_vc) {
            $key = $cform->name;
            $value = $cform->id;
           }

           $forms[$key] = $value;
         }
       }
     }

     return $forms;
  }
}


if ( ! function_exists( 'vc_get_fd_forms' ) ) {
 function vc_get_fd_forms() {
   $forms = array( esc_html__('- Select form -','prague-plugins') => 'none' );
   
   if ( ! function_exists( 'is_plugin_active' ) ) {
     include_once( ABSPATH . 'wp-admin/includes/plugin.php' ); // Require plugin.php to use is_plugin_active() below
   }

   if ( is_plugin_active( 'formidable/formidable.php' ) ) {
     global $wpdb;
     
     // $db_cf7froms = $wpdb->get_results("SELECT `id`, `name` FROM $wpdb->frm_items  WHERE `1`");

     $where = array(
     'status' => array( null, '', 'published' ),
   );
   $forms_arr = FrmForm::getAll( $where, 'name' );
     if(  $forms_arr ) {
       foreach ( $forms_arr as $cform ) {
         $forms[$cform->name] = $cform->id;
       }
     }
   }

   return $forms;
 }
}
