<?php
/*
 * Headings Shortcode
 * Author: FOXTHEMES
 * Author URI: http://foxthemes.com
 * Version: 1.0.0 
 */
if (function_exists('vc_map')) {
	vc_map( 
		array(
			'name'						=> esc_html__( 'Headings', 'js_composer' ),
			'base'						=> 'vc_headings',
			'content_element'			=> true,
			'show_settings_on_create'	=> true,
			'description'				=> esc_html__( '', 'js_composer'),
			'params'					=> array ( 
  array (
    'param_name' => 'subtitle',
    'type' => 'textfield',
    'description' => '',
    'heading' => 'Subtitle',
    'value' => '',
  ), 
  array (
    'param_name' => 'enable_divider',
    'type' => 'checkbox',
    'description' => '',
    'heading' => 'Enable divider',
    'value' => '',
  ), 
  array (
    'param_name' => 'title',
    'type' => 'textarea',
    'description' => '',
    'heading' => 'Title',
    'value' => '',
  ), 
  array (
    'param_name' => 'content_divider',
    'type' => 'checkbox',
    'description' => '',
    'heading' => 'Content divider',
    'value' => '',
  ), 
  array (
    'param_name' => 'content',
    'type' => 'textarea_html',
    'description' => '',
    'heading' => 'Content',
    'value' => '',
  ), 
  array (
    'param_name' => 'align',
    'type' => 'dropdown',
    'description' => '',
    'heading' => 'Align',
    'value' => 
      array (
        esc_html__('Left', 'left'),
        esc_html__('Center', 'center')
      ),
  ),
  array(
      'param_name'  => 'color_style',
      'type'        => 'dropdown',
      'description' => '',
      'heading'     => 'Color style',
      'value'       => array(
          'Default (Dark)' => 'dark',
          'Light'          => 'light',
      ),
  ),
  array (
    'type' => 'textfield',
    'heading' => 'Extra class name',
    'param_name' => 'el_class',
    'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
    'value' => '',
  ), 
  array (
    'type' => 'css_editor',
    'heading' => 'CSS box',
    'param_name' => 'css',
    'group' => 'Design options',
  ),
)
			//end params
		) 
	);
}
if (class_exists('WPBakeryShortCode')) {
	/* Frontend Output Shortcode */
	class WPBakeryShortCode_vc_headings extends WPBakeryShortCode {
		protected function content( $atts, $content = null ) {
			/* get all params */
			extract( shortcode_atts( array(
							'subtitle'	=> '',
						'enable_divider'	=> '',
            'color_style'       => 'dark',
						'title'	=> '',
						'content_divider'	=> '',
						'align'	=> 'left',
						'el_class'	=> '',
						'css'	=> '',
			
			), $atts ) );
			
      $css_classes = array(
        $this->getExtraClass( $el_class )
      );
      $wrap_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $css_classes ) ), $this->settings['base'], $atts );
      /* get custum css as class*/
      $wrap_class .= vc_shortcode_custom_css_class( $css, ' ' );
      $wrap_class .= !empty( $el_class ) ? ' ' . $el_class : '';

      $wrap_class .= !empty($align) ? ' ' . $align : '';

      if (!empty($color_style)){
        $wrap_class .= ' ' . esc_attr($color_style);
      }
			
			// start output
			ob_start(); 
			?>
				<section class="heading <?php echo esc_attr( $wrap_class ); ?>">

          <?php if(!empty($subtitle)) : ?><div class="subtitle <?php if(!empty($enable_divider)) : ?>divider<?php endif; ?>"><?php echo esc_html($subtitle); ?></div><?php endif; ?>
          <?php if(!empty($title)) : ?><h2 class="title"><?php echo wp_kses_post($title); ?></h2><?php endif; ?>
          <?php if(!empty($content)) : ?><div class="content <?php if(!empty($content_divider)) : ?>divider-content<?php endif; ?>"><p><?php echo wp_kses_post($content); ?></p></div><?php endif; ?>
        </section>
        <?php 
        // end output
			 return ob_get_clean();
		}
	}
}
