<?php
/**
 * Footer template.
 *
 * @package prague
 * @since 1.0.0
 *
 */

$footer = true;
$page_id = is_home() ? get_option('page_for_posts') : get_the_ID();
$meta_data = get_post_meta( $page_id, 'prague_post_options', true );
$meta_data_service = get_post_meta( $page_id, 'service_post_options', true );
// Style footer
$footer_style = ( isset( $meta_data['style_footer'] ) && $meta_data['style_footer'] == 'modern' ) ? 'modern' : 'default';

if ( isset($meta_data['page_footer']) && $meta_data['page_footer'] || isset($meta_data_service['page_footer']) && $meta_data_service['page_footer']) {
    $footer = false;
} ?>

<?php if($footer) : ?>
    <!-- START FOOTER -->
    <footer class="prague-footer <?php echo esc_attr( $footer_style ); ?>">


        <?php if ( isset( $footer_style ) && $footer_style == 'default' ) :
            echo wp_get_attachment_image( cs_get_option('footer_image'), 'full', '', array('class'=>'s-img-switch') );
        endif; ?>

        <div class="footer-content-outer">

            <?php if ( isset( $footer_style ) && $footer_style == 'default' ) : ?>
                <div class="footer-top-content">
                    <div class="prague-footer-main-block">

                        <?php footer_logo(); ?>

                        <?php if (cs_get_multilang_option('footer_content')): ?>
                            <div class="footer-main-content">
                                <?php
                                echo wp_kses_post( wpautop( do_shortcode( cs_get_multilang_option('footer_content') ) ) );
                                ?>
                            </div>
                        <?php endif ?>

                    </div>
                    <div class="prague-footer-info-block">

                        <?php if ( cs_get_multilang_option('main_title') ): ?>
                            <h6 class="footer-info-block-title"><?php echo esc_html( cs_get_multilang_option('main_title') ); ?></h6>
                        <?php endif ?>

                        <?php if ( cs_get_multilang_option('main_content') ): ?>
                            <div class="footer-info-block-content">
                                <?php echo wp_kses_post( wpautop( do_shortcode( cs_get_multilang_option('main_content') ) ) ); ?>
                            </div>
                        <?php endif ?>

                    </div>
                </div>
            <?php endif; ?>
            <div class="footer-bottom-content">

                <!-- Footer copyright -->
                <?php if (  cs_get_multilang_option('footer_copyright') ): ?>
                    <div class="footer-copyright">
                        <?php echo wp_kses_post( wpautop( cs_get_multilang_option('footer_copyright') ) ); ?>
                    </div>
                <?php else: ?>
                    <div class="footer-copyright">
                        <?php esc_html_e('PRAGUE (C) 2017 ALL RIGHTS RESERVED', 'prague'); ?>
                    </div>
                <?php endif; ?>
                <!-- End footer copyright -->

                <?php
                // render social icons
                if ( cs_get_option('footer_social_show' ) ) {
                    prague_social_nav( cs_get_option('prague_footer_social') );
                } ?>

            </div>
        </div>

    </footer>

	<?php if ( cs_get_option('page_scroll_up') ): ?>
		<!-- SCROLL TOP BUTTON -->
		<div class="prague-scroll-top"></div>
		<!-- END SCROLL TOP BUTTON -->
	<?php endif; ?>

<?php endif; ?>

	    <?php wp_footer(); ?>
	</body>
</html>

