<?php 
$prague_post_options = get_post_meta( get_the_ID(), 'prague_post_options', true );

$projects_pix_categories = ''; 
if ( function_exists('get_pixfields') ) {
	$projects_pix_categories = get_pixfields( get_the_ID() );
}
?>
<div class="project-detail-before">
	
	<?php if (!empty($prague_post_options['image_before']) && !empty($prague_post_options['image_after'])): ?>
	<div class="projects-detail-before-banner">
		<div class="ba-slider">
			<?php if (!empty($prague_post_options['image_before'])): ?>
				<?php echo wp_get_attachment_image( $prague_post_options['image_before'], 'full', '', array('class'=>'s-img-switch') ); ?>
			<?php endif ?>

			<?php if (!empty($prague_post_options['image_after'])): ?>
			<div class="resize">
				<?php echo wp_get_attachment_image( $prague_post_options['image_after'], 'full', '', array('class'=>'s-img-switch') ); ?> 
			</div>
			<?php endif ?>
			<span class="handle"></span>
			<a href="#" class="button prev"><?php esc_html_e('BEFORE', 'prague'); ?></a>
			<a href="#" class="button next"><?php esc_html_e('AFTER', 'prague'); ?></a>
		</div>
	</div>
	<?php endif ?>


	<div class="container padd-only-xs project-detail-before-outer">
		<div class="row">
			<div class="col-xs-12">
				
				<?php if (!empty($prague_post_options['active_title'])): ?>
					<div class="project-detail-before-content">

						<?php if (!empty($prague_post_options['subtitle'])): ?>
							<h6 class="project-detail-before-content-subtitle"><?php echo esc_html( $prague_post_options['subtitle'] ); ?></h6>
						<?php endif ?> 

						<?php the_title( '<h1 class="project-detail-before-content-title">', '</h1>' ); ?> 
					</div>
				<?php endif ?>

				<?php the_content(); ?>

				<?php if (!empty($prague_post_options['iframe_3d'])): ?>
				<div class="row">
					<div class="col-xs-12">
						<div class="project-details-before-3d">
							<?php echo wp_kses( $prague_post_options['iframe_3d'] , array( 'iframe' => 
								// enable attributes
								array(
										'src'             => array(),
										'height'          => array(),
										'width'           => array(),
										'frameborder'     => array(),
										'allowfullscreen' => array(),
								)) ); ?>
						</div>
					</div>
				</div>
				<?php endif ?>

				<?php if (!empty($projects_pix_categories) && !empty($prague_post_options['show_details'])): ?>
					<div class="row">
						<div class="col-xs-12">
							<div class="project-detail-block-outer">
							<?php foreach ($projects_pix_categories as $key => $pixfield) : 
								$pixfield_value = get_pixfield($key, get_the_id());
								if (!empty($pixfield_value )): ?>
										<div class="project-detail-block-wrapper">
											<div class="project-detail-block-item">
												<?php if (!empty($pixfield['label'])): ?>
												<div class="project-detail-block-title">
													<?php echo esc_html( $pixfield['label'] ); ?>
												</div>
												<?php endif ?>

												<div class="project-detail-block-descr">
													<p><?php echo esc_html( $pixfield_value ); ?></p>
												</div>
											</div>
										</div>
								<?php endif ?>
							<?php endforeach; ?>
							</div>
						</div>
					</div>
				<?php endif ?>

			</div>
		</div>
	</div>

</div>