<?php 
$prague_post_options = get_post_meta( get_the_ID(), 'prague_post_options', true );

$projects_pix_categories = ''; 
if ( function_exists('get_pixfields') ) {
	$projects_pix_categories = get_pixfields( get_the_ID() );
}
?>
<div class="project-detail-gallery">
	
	<?php if (!empty($prague_post_options['active_title'])): ?>
	<section class="container-fluid top-banner no-padd simple fullheight light">
		<span class="overlay"></span>
		<?php the_post_thumbnail( 'full', array('class'=>'s-img-switch') ); ?> 
		<div class="content">
			<?php if (!empty($prague_post_options['subtitle'])): ?>
				<div class="subtitle">
					<?php echo esc_html( $prague_post_options['subtitle'] ); ?>
				</div>
			<?php endif ?> 
			<?php the_title( '<h1 class="title">', '</h1>' ); ?>
		</div>
	</section>
	<?php endif ?>


	<?php if (!empty($prague_post_options['gallery'])): ?>
	<div class="container-fluid project-detail-gallery-outer">
		<div class="row">
			<div class="col-xs-12">
				<div class="project-detail-gallery-wrapper">

					<?php 
					$images = explode(',', $prague_post_options['gallery']); 
					foreach ($images as $key => $image_id) :

						$image_data = wp_get_attachment_image_src( $image_id, 'full' );

						if (!empty($image_data) && is_array($image_data)) :

							// calculate ratio
                            if($image_data[2]){
                                $ratio =  $image_data[1] / $image_data[2];
                            }

							$class_size = "full-width";
							if ($ratio < 1) {
								$class_size = 'full-height';
							}

							$url = is_array($image_data) ? $image_data[0] : $image_data;
							$attachment = get_post( $image_id );
							?>
							<div class="detail-gallery-item-wrapp <?php echo esc_attr( $class_size ); ?>">
								<div class="detail-gallery-item">
									<span class="detail-gallery-item-img">
										<img src="<?php echo esc_url( $url ); ?>">
										<div class="detail-gallery-item-overlay">
											<div class="vertical-align">
											<?php if (!empty($attachment->post_excerpt)): ?>
												<h4 class="detail-gallery-item-caption">
													<?php echo esc_html( $attachment->post_excerpt ); ?>
												</h4>
											<?php endif ?>
											</div>
										</div>
									</span>
								</div>
							</div>
							<?php

						endif;
						
					endforeach; ?>
					
				</div>
			</div>
		</div>
	</div>
	<?php endif; ?>

</div>
