<?php $prague_post_options = get_post_meta( get_the_ID(), 'prague_post_options', true ); ?>
<div class="project-detail-parallax" data-parallax-speed="0.5" data-smoothscrolling="">

	<div class="project-detail-parallax-item">

		<?php if ( has_post_thumbnail() ): ?>
		<div class="detail-parallax-item-bg js-detail-parallax-item-bg">
			<?php the_post_thumbnail( 'full', array('class'=>'') ); ?>
		</div>
		<?php endif; ?>

		<?php if (!empty($prague_post_options['active_title'])): ?>
		<div class="detail-parallax-item-header">
			<?php if(!empty($prague_post_options['subtitle'])): ?>
				<h6 class="detail-parallax-item-header-subtitle">
					<?php echo esc_html( $prague_post_options['subtitle'] ); ?>
				</h6>
			<?php endif ?>

			<?php the_title( '<h1 class="detail-parallax-item-header-title">', '</h1>' ); ?>
		</div>
		<?php endif ?>

	</div>
	
	<?php if (!empty($prague_post_options['gallery'])): 
		$gallery = explode(',', $prague_post_options['gallery']);
		foreach ($gallery as $key => $image_id) : ?>
			<div class="project-detail-parallax-item">

				<div class="detail-parallax-item-bg js-detail-parallax-item-bg">
					<?php echo wp_get_attachment_image( $image_id, 'full' ); ?>
				</div>

				<?php if ( $key == count($gallery) - 1 && !empty($prague_post_options['footer_copiright']) ): ?>
				<div class="detail-parallax-item-footer">
					<h6 class="detail-parallax-item-footer-subtitle">
						<?php echo esc_html( $prague_post_options['footer_copiright'] ); ?>
					</h6>
				</div>
				<?php endif; ?>

			</div>
		<?php endforeach; ?>
	<?php endif ?>

	<div class="project-detail-parallax-cover"></div>
	
	<div class="container padd-only-xs">
		<?php the_content(); ?>
	</div>

</div>
